/*
 * Decompiled with CFR 0.152.
 */
package com.divot.tetraenlarged.items.modular.impl;

import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.mutil.network.PacketHandler;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.items.TetraItemGroup;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.items.modular.ItemModularHandheld;
import se.mickelus.tetra.module.SchematicRegistry;
import se.mickelus.tetra.module.schematic.RemoveSchematic;
import se.mickelus.tetra.module.schematic.RepairSchematic;
import se.mickelus.tetra.module.schematic.UpgradeSchematic;

public class ModularLargeBladedItem
extends ItemModularHandheld {
    public static final String bladeKey = "greatsword/blade";
    public static final String hiltKey = "greatsword/hilt";
    public static final String guardKey = "greatsword/guard";
    public static final String pommelKey = "greatsword/pommel";
    public static final String fullerKey = "greatsword/fuller";
    public static final String identifier = "modular_greatsword";
    @ObjectHolder(registryName="item", value="tetra:modular_greatsword")
    public static ModularLargeBladedItem instance;

    public ModularLargeBladedItem() {
        super(new Item.Properties().m_41487_(1).m_41491_((CreativeModeTab)TetraItemGroup.instance).m_41486_());
        this.blockDestroyDamage = 2;
        this.majorModuleKeys = new String[]{bladeKey, hiltKey};
        this.minorModuleKeys = new String[]{fullerKey, guardKey, pommelKey};
        this.requiredModules = new String[]{bladeKey, hiltKey};
        this.updateConfig((Integer)ConfigHandler.honeSwordBase.get(), (Integer)ConfigHandler.honeSwordIntegrityMultiplier.get());
        SchematicRegistry.instance.registerSchematic((UpgradeSchematic)new RepairSchematic((IModularItem)this, identifier));
        RemoveSchematic.registerRemoveSchematics((IModularItem)this, (String)identifier);
    }

    public void commonInit(PacketHandler packetHandler) {
        DataManager.instance.synergyData.onReload(() -> {
            this.synergies = DataManager.instance.getSynergyData("greatsword/");
        });
    }

    public void updateConfig(int honeBase, int honeIntegrityMultiplier) {
        this.honeBase = honeBase;
        this.honeIntegrityMultiplier = honeIntegrityMultiplier;
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_220152_(group)) {
            items.add((Object)this.setupGreatSwordStack("iron", "stick"));
        }
    }

    private ItemStack setupGreatSwordStack(String bladeMaterial, String hiltMaterial) {
        ItemStack itemStack = new ItemStack((ItemLike)this);
        IModularItem.putModuleInSlot((ItemStack)itemStack, (String)bladeKey, (String)"greatsword/heavy_blade", (String)"greatsword/heavy_blade_material", (String)("heavy_blade/" + bladeMaterial));
        IModularItem.putModuleInSlot((ItemStack)itemStack, (String)hiltKey, (String)"greatsword/basic_hilt", (String)"greatsword/basic_hilt_material", (String)("basic_hilt/" + hiltMaterial));
        IModularItem.putModuleInSlot((ItemStack)itemStack, (String)guardKey, (String)"greatsword/makeshift_guard", (String)"greatsword/makeshift_guard_material", (String)("makeshift_guard/" + bladeMaterial));
        IModularItem.putModuleInSlot((ItemStack)itemStack, (String)pommelKey, (String)"greatsword/decorative_pommel", (String)"greatsword/decorative_pommel_material", (String)("decorative_pommel/" + bladeMaterial));
        IModularItem.updateIdentifier((ItemStack)itemStack);
        return itemStack;
    }

    public String getModelCacheKey(ItemStack itemStack, LivingEntity entity) {
        if (this.isThrowing(itemStack, entity)) {
            return super.getModelCacheKey(itemStack, entity) + ":throwing";
        }
        if (this.isBlocking(itemStack, entity)) {
            return super.getModelCacheKey(itemStack, entity) + ":blocking";
        }
        return super.getModelCacheKey(itemStack, entity);
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getTransformVariant(ItemStack itemStack, @Nullable LivingEntity entity) {
        if (this.isThrowing(itemStack, entity)) {
            return "throwing";
        }
        if (this.isBlocking(itemStack, entity)) {
            return "blocking";
        }
        return null;
    }
}

